<?php
/******************************************************************************
Site Building System "Web-Pro". Control script
Copyright (C) 2003 - 2007 Richter (richter@wpdom.com)
http://sbs.wpdom.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

$tmp_runstart = microtime(); // Time of starting of script

// Fast simple output of a image
if ($img) {
  $fp = @fopen($img, 'r');
  $dump = @fread($fp, filesize($img));
  @fclose($fp);
  if (substr($dump, 0, 6)!='GIF89a' and substr($dump, 0, 6)!='GIF87a'
    and substr($dump, 6, 4)!='JFIF' and substr($dump, 6, 4)!='Exif'
    and substr($dump, 1, 3)!='PNG') {
      echo 'SBS WP: Inadmissible type of file!';
      exit;
  } else {
    header("Content-type: image/gif");
    echo $dump;
    exit;
  }
}

define('_MOBJ_MODULES_FOLDER_', 'modules/'); // Folder with modules (with slash at the end)
$config_stage = 1;
require _MOBJ_MODULES_FOLDER_.'u0/config.php';

session_start();
session_register('pers_set');

// Special headers
Header("Content-Type: text/html; charset=windows-1251");
Header("Last-Modified: ".date('r'));
Header("Expires: Mon, 01 Jul 2007 01:00:00 GMT");
Header("Cache-Control: no-cache, must-revalidate");
Header("Pragma: no-cache");

// Auxiliary libraries
include_once _MOBJ_MODULES_FOLDER_.'u0/lib_ouf.php';
include_once _MOBJ_MODULES_FOLDER_.'u0/lib_calendar.php';
include_once _MOBJ_MODULES_FOLDER_.'u0/lib_mail.php';
include_once _MOBJ_MODULES_FOLDER_.'u0/lib_errors.php';
include_once _MOBJ_MODULES_FOLDER_.'u0/lib_db.php';

include_once _MOBJ_MODULES_FOLDER_.'u0/lib_u0.php';
$mobj = new SBS_WP; // Creating main object of SBS "Web-Pro"

// Creating antibot code and writing image
if ($antibot_image) {
  antibot_image($ab_digits, $ab_bg, $ab_font, $ab_color);
  exit;
}

if ($sbswp_error == '303') $mmm = get_script_name(); // Trying to search wrong typed address

$mobj->runtime['start'] = $tmp_runstart;
$mobj->runtime['after_includes'] = microtime();

$config_stage = 2;
require _MOBJ_MODULES_FOLDER_.'u0/config.php';

$mobj->EP_from_addr = $mobj->EP_to_addr = $mobj->email_admin;

if (!empty($mobj->DB)) $mobj->DB_connect(); // Connecting to database

if (!$pers_set) { // Loading of default profile
  unset($pers_set);
  $pers_set[login]	= 'guest';
  $pers_set[psw]	= 'guest';
}

$mobj->runtime['before_lng'] = microtime();

load_lng(); // Language constants of project
load_lng('u0/');

$mobj->runtime['after_lng'] = microtime();

$config_stage = 3;
require _MOBJ_MODULES_FOLDER_.'u0/config.php';

$mobj->EP_from_name = _MOBJ_PRJ_NAME_;

if (!isset($mmm) or empty($mmm)) $mmm = 'index';

// Type of decoration from personal settings
if ($pers_set[decor_folder]) $mobj->decor_folder = $pers_set[decor_folder];
if ($pers_set[decor_file]) $mobj->decor_file = $pers_set[decor_file];

// Processing a Project script
$inc_ok = FALSE;
if (file_exists(_MOBJ_MODULES_FOLDER_.'u6/') and file_exists(_MOBJ_MODULES_FOLDER_.'u15/')) { // Searching in database
  include_once _MOBJ_MODULES_FOLDER_.'u15/lib_u15.php';
  $o_u15 = new U15_1('sbs_wp_u6_pages');
  $page_data = $o_u15->u15get_record('', '', '', "filename='"._MOBJ_MODULES_FOLDER_."$mmm.php'");
  if ($page_data->id) {
    $mobj->title	= $page_data->mobj_title;
    $mobj->keywords	= $page_data->mobj_keywords;
    $mobj->decor_folder	= $page_data->decor_folder;
    $mobj->decor_file	= $page_data->decor_file;
    if (!$page_data->act) $mobj->page_disabled = TRUE;
  }
}
if (file_exists(_MOBJ_MODULES_FOLDER_.$mmm.'.php')) {
  ob_start();
  include _MOBJ_MODULES_FOLDER_.$mmm.'.php';
  if (!$mobj->page_disabled) {
    $mobj->out = ob_get_contents();
    $inc_ok = TRUE;
  }
  ob_end_clean();
}

// If page not found
if (!$inc_ok) {
  if ($mobj->mmm_404!='' and file_exists(_MOBJ_MODULES_FOLDER_.$mobj->mmm_404.'.php')) { // Trying to substitution of a page "Error 404"
    $mmm = $mobj->mmm_404;
  } else {
    $mmm = 'u0/cp/404';
  }
  ob_start();
  include _MOBJ_MODULES_FOLDER_.$mmm.'.php';
  $mobj->out = ob_get_contents();
  ob_end_clean();
  $mobj->err_proc(_LNG_U00_ERR4_, 'lm');
}

// If access denied
if ($mobj->perm_dnd) {
  $mobj->out = '';
  if (file_exists(_MOBJ_MODULES_FOLDER_.$mobj->mmm_403.'.php')) {
    $mmm = $mobj->mmm_403;
  } else {
    $mmm = 'u0/cp/403';
  }
  ob_start();
  include _MOBJ_MODULES_FOLDER_.$mmm.'.php';
  $mobj->out = ob_get_contents();
  ob_end_clean();
  $mobj->err_proc(_LNG_U00_ERR7_,'lm');
}

$mobj->runtime['before_decor'] = microtime();

// Preparing and including a decoration of page
if ($mobj->write_hf) {
  // Title preparation
  if ($mobj->title!='') $mobj->title = str_replace('[TITLE]',$mobj->title,_MOBJ_TITLE_TMPL_);
  else $mobj->title = _MOBJ_TITLE_DFLT_;

  // Keywords preparation
  if ($mobj->keywords != '') $mobj->keywords = _MOBJ_CMN_KEYWORDS_.(_MOBJ_CMN_KEYWORDS_!=''?', ':'').$mobj->keywords;
  else $mobj->keywords = _MOBJ_CMN_KEYWORDS_;

  $h_filename = _MOBJ_THEMES_FOLDER_.($mobj->decor_folder?$mobj->decor_folder:_MOBJ_DECOR_FOLDER_).($mobj->decor_file?$mobj->decor_file:_MOBJ_DECOR_FILE_);
  if (file_exists($h_filename)) {
    ob_start();
    include($h_filename);
    $mobj->out = ob_get_contents();
    ob_end_clean();
  } else $mobj->err_proc(_LNG_U00_ERR3_.' ("'.$h_filename.'")', 'lm', __FILE__, __LINE__);
}

$mobj->runtime['before_echo'] = microtime();

if ($mobj->show_error_stack and $mmm!=$mobj->mmm_404) echo $mobj->err_write();
echo $mobj->out;

$mobj->runtime['finish'] = microtime();
// echo $mobj->runtime_count(TRUE); // Statistics of runtime (debug information)
?>