<?php
/******************************************************************************
WYSIWYG Editor "Ardzon"
Copyright (C) 2006 - 2007 Richter

Main PHP library
******************************************************************************/

//************************** Editor settings **********************************
$ardzon_path		= 'ardzon/';
$ardzon_path_pics	= 'ardzon/pics/';
$ardzon_dialog_script	= 'dialog.php?';
$ardzon_external_css	= 'ardzon/style.css';
$ardzon_internal_css	= 'ardzon/work_area.css';
$ardzon_styles		= array(); // Classes, available in style-select (array with couples "class-description")
$ardzon_data_folder	= 'data/'; // Folder for pictures

// Uncomment, if use editor with SBS "Web-Pro"
$ardzon_path		= _MOBJ_MODULES_FOLDER_.'u0/ardzon/';
$ardzon_path_pics	= _MOBJ_MODULES_FOLDER_.'u0/ardzon/pics/';
$ardzon_dialog_script	= 'index.php?mmm=u0/ardzon/main';
$ardzon_external_css	= _MOBJ_THEMES_FOLDER_.'integral/default.css';
$ardzon_internal_css	= _MOBJ_MODULES_FOLDER_.'u0/ardzon/work_area.css';
$ardzon_styles		= array(); // Classes, available in style-select (array with couples "class-description")
$ardzon_data_folder	= 'data/wysiwyg_pictures/';
//*********** End of Editor settings. Don't change anything below *************

@include_once $ardzon_path.'lang/lng_'.$pers_set[lng].'.php';
@include_once $ardzon_path.'lang/lng_'.$HTTP_ACCEPT_LANGUAGE.'.php';
@include_once $ardzon_path.'lang/lng_en.php'; // Default language, if not found any other

echo '
	<script type="text/javascript">
		var ardzon_path = \''.$ardzon_path.'\';
		var ardzon_path_pics = \''.$ardzon_path_pics.'\';
		var ardzon_external_css = \''.$ardzon_external_css.'\';
		var ardzon_internal_css = \''.$ardzon_internal_css.'\';
	</script>
	<script src="'.$ardzon_path.'lang/lng_'.($pers_set[lng]?$pers_set[lng]:'en').'.js" type="text/javascript"></script>
	<script type="text/javascript">
		var ServerScriptInsertionStart = \'<div class="ardzon_server_script">\'+Lng._LNG_ARDZON_SSI_WARNING_+\'<!\'+\'-- Server Script Start\';
		var ServerScriptInsertionStart_IE = \'<div class=ardzon_server_script>\'+Lng._LNG_ARDZON_SSI_WARNING_+\'<!\'+\'-- Server Script Start\'; // Specially without quotes
	</script>
';

// Return WYSIWYG field
function get_wysiwyg_field($form_name, $field_name, $field_value = '', $width = '100%', $height = '100')
{
  global $pers_set, $ardzon_path, $ardzon_path_pics, $ardzon_dialog_script, $ardzon_styles;
  if (empty($width)) $width = '100%';
  if (empty($height)) $height = '100';
  $width_style = $width;
  if (is_numeric($width)) $width_style .= 'px';
  $height_style = $height;
  if (is_numeric($height)) $height_style .= 'px';
  $out = '
	<script src="'.$ardzon_path.'lib_main.js" type="text/javascript"></script>
	<script type="text/javascript">
	Ardzon.dialog_script = \''.$ardzon_dialog_script.'\';
	</script>

	<div id="ardzon_'.$field_name.'_toolbar" class="ardzon_toolbar">

	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'undo\', \'undo\', Lng._LNG_ARDZON_UNDO_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'redo\', \'redo\', Lng._LNG_ARDZON_REDO_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'cut\', \'cut\', Lng._LNG_ARDZON_CUT_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'copy\', \'copy\', Lng._LNG_ARDZON_COPY_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'paste\', \'paste\', Lng._LNG_ARDZON_PASTE_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'filterpaste\', \'filterpaste\', Lng._LNG_ARDZON_FILTERPASTE_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'create_hyperlink\', \'a\', Lng._LNG_ARDZON_HREF_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'inserthorizontalrule\', \'hr\', Lng._LNG_ARDZON_HR_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'inserttable\', \'tab\', Lng._LNG_ARDZON_TABLE_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'insertimage\', \'img\', Lng._LNG_ARDZON_IMAGE_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'insertflash\', \'flash\', Lng._LNG_ARDZON_FLASH_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'forecolor\', \'cfg\', Lng._LNG_ARDZON_FORECOLOR_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'bAckcolor\', \'cbg\', Lng._LNG_ARDZON_BACKCOLOR_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'visual_aid\', \'visual_aid\', Lng._LNG_ARDZON_VISUAL_AID_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'removeformat\', \'f\', Lng._LNG_ARDZON_REMOVEFORMAT_);
	</script>

	<div style="clear: both"></div>

	<div class="ardzon_b_div">
			<select id="'.$field_name.'_style" onchange="Ardzon.processAction(\'set_style\', \''.$field_name.'\')">
				<option value="">---</option>
  ';
  foreach ($ardzon_styles as $I=>$val) $out .= '<option value="'.$I.'">'.$val.'</option>';
  $out .= '
			</select>
			<select id="'.$field_name.'_fface" onchange="Ardzon.processAction(\'fontname\', \''.$field_name.'\', document.getElementById(\''.$field_name.'_fface\').value)">
				<option value="Arial" style="font-family: Arial">Arial</option>
				<option value="Courier New" style="font-family: Courier New">Courier New</option>
				<option value="Tahoma" style="font-family: Tahoma">Tahoma</option>
				<option value="Times New Roman" style="font-family: Times New Roman">Times New Roman</option>
				<option value="Verdana" selected="selected" style="font-family: Verdana">Verdana</option>
			</select>
			<select id="'.$field_name.'_fsize" onchange="Ardzon.processAction(\'fontsize\', \''.$field_name.'\', document.getElementById(\''.$field_name.'_fsize\').value)">
				<option value="1">1</option>
				<option value="2" selected="selected">2</option>
				<option value="3">3</option>
				<option value="4">4</option>
				<option value="5">5</option>
				<option value="6">6</option>
				<option value="7">7</option>
			</select>
	</div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'bold\', \'b\', Lng._LNG_ARDZON_BOLD_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'italic\', \'i\', Lng._LNG_ARDZON_ITALIC_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'underline\', \'u\', Lng._LNG_ARDZON_UNDERLINE_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'strikethrough\', \'s\', Lng._LNG_ARDZON_STRIKETHROUGH_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'superscript\', \'sup\', Lng._LNG_ARDZON_SUP_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'subscript\', \'sub\', Lng._LNG_ARDZON_SUB_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'justifyleft\', \'l\', Lng._LNG_ARDZON_JUSTIFYLEFT_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'justifycenter\', \'c\', Lng._LNG_ARDZON_JUSTIFYCENTER_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'justifyright\', \'r\', Lng._LNG_ARDZON_JUSTIFYRIGHT_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'justifyfull\', \'j\', Lng._LNG_ARDZON_JUSTIFYFULL_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'insertorderedlist\', \'ol\', Lng._LNG_ARDZON_OL_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'insertunorderedlist\', \'ul\', Lng._LNG_ARDZON_UL_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'indent\', \'in\', Lng._LNG_ARDZON_INDENT_);
	Ardzon.getToolbarButton(\''.$field_name.'\', \'outdent\', \'out\', Lng._LNG_ARDZON_OUTDENT_);
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'FormatBlock\', \'h1\', \'H1\', \'<h1>\');
	Ardzon.getToolbarButton(\''.$field_name.'\', \'FormatBlock\', \'h2\', \'H2\', \'<h2>\');
	Ardzon.getToolbarButton(\''.$field_name.'\', \'FormatBlock\', \'h3\', \'H3\', \'<h3>\');
	Ardzon.getToolbarButton(\''.$field_name.'\', \'FormatBlock\', \'h4\', \'H4\', \'<h4>\');
	</script>
	<div class="ardzon_b_divider"></div>
	<script type="text/javascript">
	Ardzon.getToolbarButton(\''.$field_name.'\', \'f1\', \'f1\', Lng._LNG_ARDZON_F1_);
	</script>

	</div>

	<div id="ardzon_'.$field_name.'_container">
		<iframe id="ardzon_'.$field_name.'_frame" width="'.$width.'" height="'.$height.'" contenteditable="true"></iframe>
	</div>
	<textarea id="ardzon_'.$field_name.'_textarea" name="'.$field_name.'" style="width:'.$width_style.'; height:'.$height_style.'; display:none"></textarea>

	<div id="ardzon_'.$field_name.'_view_normal">
		<img name="Normal" src="'.$ardzon_path_pics.'view_normal.gif" width="108" height="17" border="0" usemap="#m_Normal_'.$field_name.'" alt="" />
		<map name="m_Normal_'.$field_name.'">
		<area shape="poly" coords="59,1,56,8,59,15,99,15,105,3,104,1,59,1" href="javascript:Ardzon.showHTML(\''.$form_name.'\', \''.$field_name.'\');">
		</map>
	</div>
	<div id="ardzon_'.$field_name.'_view_html" style="display:none">
		<img name="HTML" src="'.$ardzon_path_pics.'view_html.gif" width="108" height="17" border="0" usemap="#m_HTML_'.$field_name.'" alt="" />
		<map name="m_HTML_'.$field_name.'">
		<area shape="poly" coords="1,1,51,0,55,9,53,15,8,15,2,3,1,1" href="javascript:Ardzon.showNormal(\''.$form_name.'\', \''.$field_name.'\');">
		</map>
	</div>

	<script language="javascript" type="text/javascript">
		Ardzon.Init("'.$field_name.'", "'.str_replace(array("\r", "\n", "</script>", "</SCRIPT>"), array("\\r", "\\n", "&lt;/script>", "&lt;/SCRIPT>"), addslashes(trim($field_value))).'");
	</script>
  ';
  return $out;
}
?>