/******************************************************************************
WYSIWYG Editor "Ardzon"
Copyright (C) 2006 - 2007 Richter

Library for work with context menu
******************************************************************************/

ContextMenu = {
  // "event" need for FF
  Build: function (event, field_name) {
    this.field_name = field_name;

    // Coordinates
    if (isGecko) {
      x = event.pageX;
      y = event.pageY;
    }
    if (isIE) {
      x = frames['ardzon_'+field_name+'_frame'].window.event.x;
      y = frames['ardzon_'+field_name+'_frame'].window.event.y;
    }
    x += document.getElementById('ardzon_'+field_name+'_frame').offsetLeft;
    y += document.getElementById('ardzon_'+field_name+'_frame').offsetTop;

    // Creating if not exists
    if (!document.getElementById('ardzon_'+field_name+'_contextmenu')) {
      if (isIE) {
        EditField[field_name].onclick = function() { ContextMenu.Hide(); }
        EditField[field_name].onkeydown = function() { ContextMenu.Hide(); }
        EditField[field_name].onkeypress = function() { ContextMenu.Hide(); }
        document.onclick = function() { ContextMenu.Hide(); }
        document.onkeydown = function() { ContextMenu.Hide(); }
        document.onkeypress = function() { ContextMenu.Hide(); }
      }
      if (isGecko) {
        EditField[field_name].addEventListener('click', function(){ContextMenu.Hide()}, true);
        EditField[field_name].addEventListener('keydown', function(){ContextMenu.Hide()}, true);
        EditField[field_name].addEventListener('keypress', function(){ContextMenu.Hide()}, true);
        document.addEventListener('click', function(){ContextMenu.Hide()}, true);
        document.addEventListener('keydown', function(){ContextMenu.Hide()}, true);
        document.addEventListener('keypress', function(){ContextMenu.Hide()}, true);
      }
      contextMenuDiv = document.createElement("div");
      contextMenuDiv.setAttribute("id", "ardzon_"+field_name+"_contextmenu");
      contextMenuDiv.className = "ardzon_contextmenu";
      contextMenuDiv.style.position = 'absolute';

      var MenuContent = "";
      MenuContent += this.AddItem('bold', Lng._LNG_ARDZON_BOLD_, "b");
      MenuContent += this.AddItem('italic', Lng._LNG_ARDZON_ITALIC_, "i");
      MenuContent += this.AddItem('underline', Lng._LNG_ARDZON_UNDERLINE_, "u");
      MenuContent += this.AddDivider();
      MenuContent += this.AddItem('cut', Lng._LNG_ARDZON_CUT_, "cut");
      MenuContent += this.AddItem('copy', Lng._LNG_ARDZON_COPY_, "copy");
      MenuContent += this.AddItem('paste', Lng._LNG_ARDZON_PASTE_, "paste");
      MenuContent += this.AddItem('filterpaste', Lng._LNG_ARDZON_FILTERPASTE_, "filterpaste");
      MenuContent += this.AddDivider();
      MenuContent += this.AddItem('insertimage', Lng._LNG_ARDZON_IMAGE_, "img");
      MenuContent += this.AddDivider();
      MenuContent += this.AddItem('inserttable', Lng._LNG_ARDZON_TABLE_, "tab");
      MenuContent += this.AddItem('table_properties', Lng._LNG_ARDZON_TABLEPROP_, "tab_properties");
      MenuContent += this.AddItem('delete_table', Lng._LNG_ARDZON_DELTABLE_, "tab_del");
//      MenuContent += this.AddItem('insert_row_before', Lng._LNG_ARDZON_INSROWBEFORE_, "tab_insrowbefore");
      MenuContent += this.AddItem('insert_row_after', Lng._LNG_ARDZON_INSROWAFTER_, "tab_insrowafter");
      MenuContent += this.AddItem('delete_row', Lng._LNG_ARDZON_DELROW_, "tab_delrow");
//      MenuContent += this.AddItem('insert_column_before', Lng._LNG_ARDZON_INSCOLBEFORE_, "tab_inscolbefore");
      MenuContent += this.AddItem('insert_column_after', Lng._LNG_ARDZON_INSCOLAFTER_, "tab_inscolafter");
      MenuContent += this.AddItem('delete_column', Lng._LNG_ARDZON_DELCOL_, "tab_delcol");
//      MenuContent += this.AddItem('split_cell', Lng._LNG_ARDZON_SPLITCELL_, "tab_splitcell");
      contextMenuDiv.innerHTML = MenuContent;

      contextMenuDiv.style.left = x+'px';
      contextMenuDiv.style.top = y+'px';
      document.body.appendChild(contextMenuDiv);
    }
    contextMenuDiv.style.left = x+'px';
    contextMenuDiv.style.top = y+'px';
    contextMenuDiv.style.display = "block";

    if (isGecko) event.preventDefault();
    return false;
  },

  AddItem : function (command, title, pic) {
    return '<div><div class="ardzon_contextmenu_icon"><a href="javascript:void(0);"><img src="'+ardzon_path_pics+pic+'.gif" /></a></div><a href="javascript:void(0);" onclick="Ardzon.processAction(\''+command+'\', \''+this.field_name+'\');">'+title+'</div></div>';
  },

  AddDivider : function () {
    return '<div class="ardzon_contextmenu_divider"><img src="'+ardzon_path_pics+'1.gif" /></div>';
  },

  Hide: function ()
  {
    contextMenuDiv.style.display = "none";
  }
}