/******************************************************************************
WYSIWYG Editor "Ardzon"
Copyright (C) 2006 - 2007 Richter

Main library and scripts
******************************************************************************/


//---------------
  function f1(Obj){
    var result = "";
    for (var I in Obj)
        result += I + " = " + Obj[I] + "<br />\n";
    document.write(result);
  }
//----------------------------


document.write('<script src="'+ardzon_path+'lib_context_menu.js" type="text/javascript"></script>');
document.write('<script src="'+ardzon_path+'lib_tables.js" type="text/javascript"></script>');
document.write('<script src="'+ardzon_path+'lib_images.js" type="text/javascript"></script>');
document.write('<script src="'+ardzon_path+'lib_hyperlinks.js" type="text/javascript"></script>');

if (navigator.userAgent.match(/gecko/i)) isGecko = true; else isGecko = false;
if (navigator.userAgent.match(/msie/i)) isIE = true; else isIE = false;
if (!Editor_List) var Editor_List = new Array();
if (!EditField) var EditField = new Array();

// Styles and start content
var StyleLink		= '<link href="'+ardzon_external_css+'" rel="STYLESHEET" type="text/css" />';
var EditFieldHeader	= '<html><head>' +
	'<link href="'+ardzon_internal_css+'" rel="STYLESHEET" type="text/css" />' + 
	(ardzon_external_css?StyleLink:'') + '</head><body style="margin: 1px 0px 0px 1px">';
var EditFieldFooter	= '</body></html>';

// Main object "Ardzon"
var Ardzon = {
  Guidelines : false, // Indicator
  CurSelection : null, // Current selection

  // Initialization
  Init : function (field_name, field_value)
  {
    // Shielding from cutting of server scripts
    field_value = field_value.replace(/<\?/gi, ServerScriptInsertionStart);
    field_value = field_value.replace(/\?>/gi, "Server Script End --></div>");

    field_value = field_value.replace(/&lt;\/script>/gi, "</script>");

    if (!isIE && !isGecko) { // If no supported
      document.getElementById("ardzon_"+field_name+"_toolbar").style.display='none';
      document.getElementById('ardzon_'+field_name+'_container').style.display = "none";
      document.getElementById('ardzon_'+field_name+'_textarea').style.display = "block";
      document.getElementById('ardzon_'+field_name+'_textarea').value = field_value;
      document.getElementById('ardzon_'+field_name+'_view_normal').style.display = "none";
      document.getElementById('ardzon_'+field_name+'_view_html').style.display = "none";
    } else {
      if (isIE) EditField[field_name] = frames['ardzon_'+field_name+'_frame'].document;
      else if (isGecko) EditField[field_name] = document.getElementById('ardzon_'+field_name+'_frame').contentDocument;

      EditField[field_name].designMode = 'On';

      EditField[field_name].open();
      EditField[field_name].write(EditFieldHeader);
      EditField[field_name].write(field_value);
      EditField[field_name].write(EditFieldFooter);
      EditField[field_name].close();

      try { // "try" for IE
        EditField[field_name].execCommand('useCSS',false,'true');
      } catch(e) {}

      if (isGecko) EditField[field_name].addEventListener('contextmenu', function(event){ContextMenu.Build(event, field_name)}, true);
      if (isIE) EditField[field_name].oncontextmenu = function() { return ContextMenu.Build(event, field_name); }

      // Registration
      Editor_List[Editor_List.length] = field_name;
    }
  },

  // Processes all actions of user
  processAction : function(TStyle, field_name, exec_arg) {
  	if (TStyle.match(/filterpaste/i)) {
          this.CurSelection = EditField[field_name].selection.createRange();
          this.openDialogWin("&amode=filter_paste&field_name="+field_name, 600, 400);
  	} else if (TStyle.match(/insertimage/i)) {
            Img = getImage(field_name);
            if (Img) { // Updating selected image
              var ImgProp = {};
              ImgProp.alt = Img.alt;
              ImgProp.width = (Img.style.width)?Img.style.width:Img.width;
              ImgProp.height = (Img.style.height)?Img.style.height:Img.height;
              ImgProp.className = Img.className;
              var tmp_win = this.openDialogWin("&amode=image_properties&field_name="+field_name, 350, 180);
              tmp_win.dialogArguments = ImgProp;
            } else { // Uploading new image
              EditField[field_name].body.focus();
              this.openDialogWin("&amode=add_image&field_name="+field_name, 250, 120);
            }
  	} else if (TStyle.match(/create_hyperlink/i)) {
            a = this.getParentNode(field_name);
            if (a.href) {
              var HyperlinkWindow = this.openDialogWin("&amode=hyperlink_properties&field_name="+field_name, 300, 270);
              HyperlinkWindow.dialogArguments = a;
            } else {
              EditField[field_name].body.focus();
              this.openDialogWin("&amode=add_hyperlink&field_name="+field_name, 300, 270);
            }
  	} else if (TStyle.match(/insertflash/i)) {
            this.openDialogWin("&amode=add_flash&field_name="+field_name, 250, 120);
  	} else if (TStyle.match(/inserttable/i)) {
          EditField[field_name].body.focus();
          this.CurSelection = EditField[field_name].selection.createRange();
          this.openDialogWin("&amode=insert_table&field_name="+field_name, 250, 320);
  	} else if (TStyle.match(/table_properties/i)) {
            Table = this.getParentNode(field_name, 'TABLE');
            var TableProp = {};
            TableProp.Obj = Table;
            TableProp.width = (Table.style.width)?Table.style.width:Table.width;
            TableProp.height = (Table.style.height)?Table.style.height:Table.height;
            var tmp_win = this.openDialogWin("&amode=table_properties&field_name="+field_name, 250, 320);
            tmp_win.dialogArguments = TableProp;
  	} else if (TStyle.match(/insert_row_before/i)) {
          InsertRow(field_name, 'before');
  	} else if (TStyle.match(/insert_row_after/i)) {
          InsertRow(field_name, 'after');
  	} else if (TStyle.match(/delete_row/i)) {
          DeleteRow(field_name);
  	} else if (TStyle.match(/insert_column_before/i)) {
          insertColumn(field_name, 'before');
  	} else if (TStyle.match(/insert_column_after/i)) {
          insertColumn(field_name, 'after');
  	} else if (TStyle.match(/delete_column/i)) {
          DeleteColumn(field_name);
  	} else if (TStyle.match(/delete_table/i)) {
          DeleteTable(field_name);
  	} else if (TStyle.match(/split_cell/i)) {
          SplitCell(field_name);
  	} else if (TStyle.match(/set_style/i)) {
          this.setStyle(field_name);
  	} else if (TStyle.match(/visual_aid/i)) {
          this.handleVisualAid(EditField[field_name].body);
	} else if (TStyle.match(/forecolor/i)) {
          this.openDialogWin("&amode=choice_fcolor&field_name="+field_name, 380, 140);
  	} else if (TStyle.match(/backcolor/i)) {
          this.openDialogWin("&amode=choice_bcolor&field_name="+field_name, 380, 140);
  	} else if (TStyle.match(/f1/i)) {
          this.openDialogWin("&amode=f1", 300, 300);
  	} else {
            EditField[field_name].execCommand(TStyle, false, exec_arg)
  	}
  },

  // Writes toolbar button
  getToolbarButton : function (field_name, style, image, title, exec_arg)
  {
    document.write('<div class="ardzon_b_div"><a href="javascript:void(0);" onclick="Ardzon.processAction(\''+style+'\', \''+field_name+'\', \''+exec_arg+'\')" title="'+title+'"><img src="'+ardzon_path_pics+image+'.gif" alt="" /></a></div>');
  },

  // Opens dialog window
  openDialogWin : function(url_suffix, width, height)
  {
    return window.open(this.dialog_script+url_suffix,"DialogWindow","dependent=1,left="+(screen.width-width)/2+",top="+(screen.height-height)/2+",width="+width+",height="+height+",status=no");
  },

  // Set borders
  setBorders : function (Node, restore)
  {
    var oldW = Node.style.width;
    var oldH = Node.style.height;
    if ((!this.Guidelines && !restore) || (restore && this.Guidelines && Node.runtimeStyle.borderWidth=='')) {
      Node.runtimeStyle.borderWidth = "1px";
      Node.runtimeStyle.borderStyle = "dashed";
      Node.runtimeStyle.borderColor = "#777777";
    } else {
      Node.runtimeStyle.borderWidth = "";
      Node.runtimeStyle.borderStyle = "";
      Node.runtimeStyle.borderColor = "";
    }
  // Really needed?
    Node.style.width = oldW;
    Node.style.height = oldH;
  },

  // Visual aid (borders)
  handleVisualAid : function (Node, restore, isChild)
  {
    if (!Node) return;
    switch (Node.nodeName) {
      case 'TABLE':
        Ardzon.setBorders(Node, restore);
        for (var y=0; y<Node.rows.length; y++) {
          for (var x=0; x<Node.rows[y].cells.length; x++) {
            Ardzon.setBorders(Node.rows[y].cells[x], restore);
          }
        }
        break;
      case 'A':
      case 'P':
      case 'DIV':
      case 'UL':
      case 'OL':
        Ardzon.setBorders(Node, restore);
        break;
    }
    if (Node.hasChildNodes()) {
      for (var I=0; I<Node.childNodes.length; I++)
        this.handleVisualAid(Node.childNodes[I], restore, true);
      }
    if (!restore && !isChild) { // Changing state
      if (!Ardzon.Guidelines) Ardzon.Guidelines = true;
      else Ardzon.Guidelines = false;
    }
  },

  // Changes a style-property of selection
  setStyle : function (field_name)
  {
    classname = document.getElementById(field_name+"_style").value;
    Obj = this.getParentNode(field_name);
    if (Obj!=null && Obj.tagName.toLowerCase()!='body') {
      if (classname != '') Obj.className = classname;
      else Obj.removeAttribute('className',0);
    } else if (Obj.tagName.toLowerCase() == 'body') {
      if (classname != '')
        EditField[field_name].body.innerHTML = '<div class="'+classname+'">'+EditField[field_name].body.innerHTML+'</div>';
    }
  },

  // Return parent specified node for current selection
  // if A empty simply return parent node
  getParentNode : function (field_name, A, make_path)
  {
    var B;
    if (make_path) {
      var path = new Array;
      A = 'HTML';
    }
    var C = EditField[field_name].selection.createRange();
    if (EditField[field_name].selection.type=="Control") {
      for (i=0;i<C.length;i++) {
        if (C(i).parentNode) {
          B = C(i).parentNode;
          break;
        }
      }
    } else {
      B = C.parentElement();
    }
    if (!A || A=='') return B;
    while (B&&B.nodeName!=A) {
      B = B.parentNode;
      if (make_path) path[path.length] = B.nodeName;
    }
    if (make_path) return path;
    else return B;
  },

  // Remove a useless tags from HTML-code
  cleanCode : function (html, actions)
  {
    var act1 = /1/;
    var act2 = /2/;
    if (act1.test(actions)) html = html.replace(/<\/?font[^>]*>/gi, "" ); // "font"
    if (act2.test(actions)) {
      html = html.replace(/<\/?SPAN[^>]*>/gi, "" ); // "span"
      html = html.replace(/<(\w[^>]*) class=([^ |>]*)([^>]*)/gi, "<$1$3") ; // "class"
      html = html.replace(/<(\w[^>]*) style="([^"]*)"([^>]*)/gi, "<$1$3") ; // "style"
      html = html.replace(/<(\w[^>]*) lang=([^ |>]*)([^>]*)/gi, "<$1$3"); // "lang"
      html = html.replace(/<\\?\?xml[^>]*>/gi, ""); // Remove XML elements and declarations
      html = html.replace(/<\/?\w+:[^>]*>/gi, "") ; // Remove Tags with XML namespace declarations: <o<img src="images/smilies/tongue.gif" border="0" alt="">></o<img src="images/smilies/tongue.gif" border="0" alt="">>
    }
    return html;
  },

  // Paste with filtering
  pasteF : function (field_name)
  {
    var _text = document.forms['pastef'].elements['_text'].value;
    if (document.forms['pastef'].elements['fword'].checked) _text = this.cleanCode(_text, '2');
    if (document.forms['pastef'].elements['ffont'].checked) _text = this.cleanCode(_text, '1');
    window.opener.Ardzon.CurSelection.pasteHTML(_text);
    window.close();
  },

  // Shows a work area in HTML mode
  showHTML : function (form_name, field_name)
  {
    document.getElementById("ardzon_"+field_name+"_view_normal").style.display = "none";
    document.getElementById("ardzon_"+field_name+"_view_html").style.display = "";
    tmp = EditField[field_name].body.innerHTML;
    document.getElementById('ardzon_'+field_name+'_container').style.display = "none";

    // Un-shielding of server scripts
    if (isIE) tmp = tmp.replace(RegExp(ServerScriptInsertionStart_IE, 'gi'), "<?");
    else tmp = tmp.replace(RegExp(ServerScriptInsertionStart, 'gi'), "<?");
    tmp = tmp.replace(/Server Script End --><\/div>/gi, "?>");
    tmp = tmp.replace(/Server Script End --&gt;<\/div>/gi, "?>"); // In case of commentaries (<!-- -->) in PHP-block

    document.forms[form_name].elements[field_name].value = tmp;
    document.forms[form_name].elements[field_name].style.display = "block";
  },

  // Shows a work area in normal mode
  showNormal : function (form_name, field_name)
  {
    document.getElementById("ardzon_"+field_name+"_view_normal").style.display = "";
    document.getElementById("ardzon_"+field_name+"_view_html").style.display = "none";
    tmp = document.forms[form_name].elements[field_name].value;
    document.forms[form_name].elements[field_name].style.display = "none";

    // Shielding from cutting of server scripts
    tmp = tmp.replace(/<\?/gi, ServerScriptInsertionStart);
    tmp = tmp.replace(/\?>/gi, "Server Script End --></div>");

    EditField[field_name].body.innerHTML = tmp;
    document.getElementById('ardzon_'+field_name+'_container').style.display = "block";
    EditField[field_name].designMode = 'On'; // Specially for Firefox
    Ardzon.handleVisualAid(EditField[field_name].body, true); // Restoring visual aid
  },

  // Fill hidden fields by values of WYSIWYG fields
  savePrepare : function (form_name)
  {
    for (var I=0;I<Editor_List.length;I++) {
      if (document.getElementById("ardzon_"+Editor_List[I]+"_view_html").style.display == 'none') {

        tmp = EditField[Editor_List[I]].body.innerHTML;

        // Un-shielding of server scripts
        if (isIE) tmp = tmp.replace(RegExp(ServerScriptInsertionStart_IE, 'gi'), "<?");
        else tmp = tmp.replace(RegExp(ServerScriptInsertionStart, 'gi'), "<?");
        tmp = tmp.replace(/Server Script End --><\/div>/gi, "?>");
        tmp = tmp.replace(/Server Script End --&gt;<\/div>/gi, "?>"); // In case of commentaries (<!-- -->) in PHP-block

        document.forms[form_name].elements[Editor_List[I]].value = tmp;
      }
    }
  }
}
// End of object "Ardzon"