// Shows/hides a filter in web-administrator
function showFilter(filter_id) {
  if (document.getElementById(filter_id).style.display == "none") {
    document.getElementById(filter_id).style.display = "block";
    setCookie(filter_id, 'block');
    document.getElementById(filter_id+"_b_open").style.display = "none";
    document.getElementById(filter_id+"_b_close").style.display = "inline";
  } else {
    document.getElementById(filter_id).style.display = "none";
    setCookie(filter_id, 'none');
    document.getElementById(filter_id+"_b_open").style.display = "inline";
    document.getElementById(filter_id+"_b_close").style.display = "none";
  }
}

// Set a cookie value
function setCookie(name, value) {
  expDate = new Date();
  expDate.setYear(expDate.getYear() + 1);
  document.cookie = name+"="+escape(value)+";expires=\"expDate.toGMTString()+\";"
}

// Return value of cookie
function getCookie(name) {
  var prefix = name + "="
  var cookieStartIndex = document.cookie.indexOf(prefix)
  if (cookieStartIndex == -1)
    return null
  var cookieEndIndex = document.cookie.indexOf(";", cookieStartIndex + prefix.length)
  if (cookieEndIndex == -1)
    cookieEndIndex = document.cookie.length
  return unescape(document.cookie.substring(cookieStartIndex + prefix.length, cookieEndIndex))
}