<?php
/******************************************************************************
Site Building System "Web-Pro"
Copyright (C) 2003 - 2007 Richter.
See "index.php" in root of project for detailed information

Library for web-administrators
******************************************************************************/

@include 'ardzon/lib.php';

// Return header block of filter
function get_filter_header($filter_id)
{
  global $mobj;
  return '
	<script src="'._MOBJ_MODULES_FOLDER_.'u0/common.js" type="text/javascript"></script>

	<div class="filter">
	<div class="header">
		<div class="title"><b>'._LNG_U00_FILTER_.'</b></div>
		<div id="'.$filter_id.'_b_open" class="arrow"><a href="javascript:showFilter(\''.$filter_id.'\')" title="'._LNG_U00_SHOW_.'"><img src="'._MOBJ_THEMES_FOLDER_.$mobj->decor_folder.'pics/filter_open.gif" alt="" /></a></div>
		<div id="'.$filter_id.'_b_close" class="arrow"><a href="javascript:showFilter(\''.$filter_id.'\')" title="'._LNG_U00_HIDE_.'"><img src="'._MOBJ_THEMES_FOLDER_.$mobj->decor_folder.'pics/filter_close.gif" alt="" /></a></div>
	</div>
	<div id="'.$filter_id.'" class="body">

	<script language="javascript" type="text/javascript">
          if (getCookie("'.$filter_id.'") == "block") {
            document.getElementById("'.$filter_id.'").style.display = "block";
            document.getElementById("'.$filter_id.'_b_open").style.display = "none";
            document.getElementById("'.$filter_id.'_b_close").style.display = "block";
          } else {
            document.getElementById("'.$filter_id.'").style.display = "none";
            document.getElementById("'.$filter_id.'_b_open").style.display = "block";
            document.getElementById("'.$filter_id.'_b_close").style.display = "none";
          }
	</script>
  ';
}

// Return block for sorting
function get_sort_block($sort_expression, $template, $order)
{
  global $mobj;
  return str_replace('[ORDER]', $sort_expression, $template).'<img src="'._MOBJ_THEMES_FOLDER_.$mobj->decor_folder.'pics/sort_up'.($sort_expression==$order?'_act':'').'.gif" alt="'._LNG_U15_SORT_.'" /></a>
'.str_replace('[ORDER]', $sort_expression.' desc', $template).'<img src="'._MOBJ_THEMES_FOLDER_.$mobj->decor_folder.'pics/sort_down'.($sort_expression.' desc'==$order?'_act':'').'.gif" alt="'._LNG_U15_SORT_.'" /></a>';
}

// Split SQL-queries in string into array of separate queries
// Unoriginal from phpMyAdmin (PMA_splitSqlFile()) and lightly modified
function split_sql(&$ret, $sql)
{
    $sql          = trim($sql);
    $sql_len      = strlen($sql);
    $char         = '';
    $string_start = '';
    $in_string    = FALSE;

    for ($i = 0; $i < $sql_len; ++$i) {
        $char = $sql[$i];

        // We are in a string, check for not escaped end of strings except for
        // backquotes that can't be escaped
        if ($in_string) {
            for (;;) {
                $i         = strpos($sql, $string_start, $i);
                // No end of string found -> add the current substring to the
                // returned array
                if (!$i) {
                    $ret[] = $sql;
                    return TRUE;
                }
                // Backquotes or no backslashes before quotes: it's indeed the
                // end of the string -> exit the loop
                else if ($string_start == '`' || $sql[$i-1] != '\\') {
                    $string_start      = '';
                    $in_string         = FALSE;
                    break;
                }
                // one or more Backslashes before the presumed end of string...
                else {
                    // ... first checks for escaped backslashes
                    $j                     = 2;
                    $escaped_backslash     = FALSE;
                    while ($i-$j > 0 && $sql[$i-$j] == '\\') {
                        $escaped_backslash = !$escaped_backslash;
                        $j++;
                    }
                    // ... if escaped backslashes: it's really the end of the
                    // string -> exit the loop
                    if ($escaped_backslash) {
                        $string_start  = '';
                        $in_string     = FALSE;
                        break;
                    }
                    // ... else loop
                    else {
                        $i++;
                    }
                }
            }
        }

        // We are not in a string, first check for delimiter...
        else if ($char == ';') {
            // if delimiter found, add the parsed part to the returned array
            $ret[]      = substr($sql, 0, $i);
            $sql        = ltrim(substr($sql, min($i + 1, $sql_len)));
            $sql_len    = strlen($sql);
            if ($sql_len) {
                $i      = -1;
            } else {
                // The submited statement(s) end(s) here
                return TRUE;
            }
        }

        // ... then check for start of a string,...
        else if (($char == '"') || ($char == '\'') || ($char == '`')) {
            $in_string    = TRUE;
            $string_start = $char;
        } // end else if (is start of string)

        // ... for start of a comment (and remove this comment if found)...
        else if ($char == '#'
                 || ($char == ' ' && $i > 1 && $sql[$i-2] . $sql[$i-1] == '--')) {
            // starting position of the comment depends on the comment type
            $start_of_comment = (($sql[$i] == '#') ? $i : $i-2);
            // if no "\n" exits in the remaining string, checks for "\r"
            // (Mac eol style)
            $end_of_comment   = (strpos(' ' . $sql, "\012", $i+2))
                              ? strpos(' ' . $sql, "\012", $i+2)
                              : strpos(' ' . $sql, "\015", $i+2);
            if (!$end_of_comment) {
                // no eol found after '#', add the parsed part to the returned
                // array if required and exit
                if ($start_of_comment > 0) {
                    $ret[]    = trim(substr($sql, 0, $start_of_comment));
                }
                return TRUE;
            } else {
                $sql          = substr($sql, 0, $start_of_comment)
                              . ltrim(substr($sql, $end_of_comment));
                $sql_len      = strlen($sql);
                $i--;
            } // end if...else
        } // end else if (is comment)
    }

    // add any rest to the returned array
    if (!empty($sql) && ereg('[^[:space:]]+', $sql)) {
      $ret[] = $sql;
    }

    return TRUE;
}
?>