<?php
/*
Library "Universal Calendar-Navigator". V1.1. Copyright (C) 2003, 04 Richter
Uses templates, flexible and easy to tune
Additional information: http://wpdom.com, richter@wpdom.com
*/

class Calendar {
  var $tmpl_day;	// Day block
  var $tmpl_daycur;	// Current day block
  var $tmpl_dayempty;	// Empty day block (stub)
  var $tmpl_url;	// URL
  var $month_names;	// Array with names of months
  var $time_var;	// Name of variables in which sent time

  function Calendar()
  {
    $this->month_names = array(january, february, march, april, may, june, july, august, september, october, november, december);
    $this->tmpl_url = '[TIME]';
    $time_var = 'clndr_time';
  }

  // Shows a calendar
  function calendar_show()
  {
    $time = $GLOBALS[$this->time_var];
    $out = '';
    if (isset($time)) {
      $y = date('Y', $time);
      $tmpmonth = date('m', $time);
      $c_day = date('d', $time);
    }
    else {
      $y = date('Y');
      $tmpmonth = date('m');
      $c_day = date('d');
    }
    $firstday = date('w', mktime (0,0,0,$tmpmonth,1,$y));
    if ($firstday == 0) $firstday = 7;
    $lastday = date('d', mktime (0,0,0,$tmpmonth+1,0,$y));

    // Table of calendar
    $count = 0;
    // Adding empty blocks before first day
    for($i=2;$i<=$firstday;$i++) {
      $days_rows .= $this->dayempty;
      $count++;
    }
    // Main days cycle
    for($i=1;$i<=$lastday;$i++) {
      if ($count == 7) {
        $days_rows .= $this->days_rows_delimiter;
        $count = 0;
      }
      $count++;
      $tmpday = date('d', mktime (0,0,0,$tmpmonth,$i,$y));
      // Links to Jump in "days"
      $eval_url = str_replace('[TIME]',mktime (0,0,0,$tmpmonth,$tmpday,$y),$this->tmpl_url);
      $eval_day = $i;
      $eval_month = $tmpmonth;
      $eval_year = $y;
      if (mktime (0,0,0,$tmpmonth,$i,$y) == mktime (0,0,0,date('m'),date('d'),date('Y'))) { // "Today"
        eval($this->tmpl_daycur);
      } else { // Other days
        eval($this->tmpl_day);
      }
      $days_rows .= $this->day;
    }
    // Adding empty blocks after last day
    if ($count<7) {
      $i = 1;
      while ($count<7) {
        $days_rows .= $this->dayempty;
        $count++;
        $i++;
      }
    }
    return $days_rows;
  }

  // Get URL for other month
  // $shift can be +-1
  function get_url_other_month($start_timestamp, $shift)
  {
    if (!$start_timestamp) $start_timestamp = time();
    $tmp_month = date('m', $start_timestamp);
    if ($shift == '-1') {
      if ($tmp_month == '01') $time = mktime (0,0,0,12, date('d', $start_timestamp), date('Y', $start_timestamp)-1);
      else $time = mktime (0,0,0,$tmp_month-1, date('d', $start_timestamp), date('Y', $start_timestamp));
    } else {
      if ($tmp_month == '12') $time = mktime (0,0,0,1, date('d', $start_timestamp), date('Y', $start_timestamp)+1);
      else $time = mktime (0,0,0,$tmp_month+1, date('d', $start_timestamp), date('Y', $start_timestamp));
    }
    return str_replace('[TIME]', $time, $this->tmpl_url);
  }

  // Get URL for other year
  function get_url_other_year($start_timestamp, $shift)
  {
    if (!$start_timestamp) $start_timestamp = time();
    return str_replace('[TIME]', mktime(0, 0, 0, date('m', $start_timestamp), date('d', $start_timestamp), date('Y', $start_timestamp)+$shift), $this->tmpl_url);
  }

  // Get normal date from timestamp (analogue of standard date())
  function date($format, $timestamp)
  {
    if (!$timestamp) $timestamp = time();
    return date($format, $timestamp);
  }
}
?>