<?php
/*
Library for work with databases. V1.5. Copyright (C) 2004 - 2007 Richter
Additional information: http://wpdom.com, richter@wpdom.com
*/

class DB_Interface extends Error_Processor {
  var $DB;						// Work database
  var $DB_host;						// Database host
  var $DB_user;						// Database user
  var $DB_psw;						// Database password
  var $SQL;						// Current SQL query
  var $DB_type = 'MySQL';				// Type of database
  var $DB_err0 = 'Unable to connect to database';	// Code of error for DB_connect()
  var $DB_err1 = 'Incorrect request to database';	// Code of error for DB_db_query()

  // Get number of affected rows in previous operation
  function DB_affected_rows($link_id = '')
  {
    switch ($this->DB_type) {
      case 'MySQL':
        if (empty($link_id)) return @mysql_affected_rows();
        else return @mysql_affected_rows($link_id);
      break;
    }
  }

  // Close a connection to database
  function DB_close($link_id)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_close($link_id);
      break;
    }
  }

  // Open a connection to database
  function DB_connect($err_actions = 'lmws')
  {
    switch ($this->DB_type) {
      case 'MySQL':
        if (!$link_id = @mysql_connect($this->DB_host,$this->DB_user,$this->DB_psw))
          $this->err_proc($this->DB_err0, $err_actions);
        else return $link_id;
      break;
    }
  }

  // Move internal result pointer
  function DB_data_seek($R, $row_number)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_data_seek($R, $row_number);
      break;
    }
  }

  // Sends a query to database, check result and processes an error if needed
  function DB_db_query($query = '', $err_actions = 'lm')
  {
    if (!empty($query)) $this->SQL = $query;
    switch ($this->DB_type) {
      case 'MySQL':
        if (!$R = @mysql_db_query($this->DB,$this->SQL)) {
          $this->err_proc($this->DB_err1.' ('.$this->SQL.')', $err_actions);
          return FALSE;
        }
        else return $R;
      break;
    }
  }

  // Fetch a result row as an array
  function DB_fetch_array($R)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_fetch_array($R);
      break;
    }
  }

  // Fetch a result row as an associative array
  function DB_fetch_assoc($R)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_fetch_assoc($R);
      break;
    }
  }

  // Fetch a result row as an object
  function DB_fetch_object($R)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_fetch_object($R);
      break;
    }
  }

  // Get a result row as an enumerated array
  function DB_fetch_row($R)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_fetch_row($R);
      break;
    }
  }

  // Free result memory
  function DB_free_result($R)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_free_result($R);
      break;
    }
  }

  // Get the ID generated from the previous INSERT operation
  function DB_insert_id($link_id = '')
  {
    switch ($this->DB_type) {
      case 'MySQL':
        if (empty($link_id)) return @mysql_insert_id();
        else return @mysql_insert_id($link_id);
      break;
    }
  }

  // List tables in a database
  function DB_list_tables()
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return mysql_list_tables($this->DB);
      break;
    }
  }

  // Get number of rows in result
  function DB_num_rows($R)
  {
    switch ($this->DB_type) {
      case 'MySQL':
        return @mysql_num_rows($R);
      break;
    }
  }

  // Get result data
  function DB_result($R, $row, $field = '')
  {
    switch ($this->DB_type) {
      case 'MySQL':
        if (empty($field)) return @mysql_result($R,$row);
        else return @mysql_result($R,$row,$field);
      break;
    }
  }
}
?>