<?php
/******************************************************************************
Site Building System "Web-Pro"
Copyright (C) 2003 - 2007 Richter.
See "index.php" in root of project for detailed information

Main library
******************************************************************************/

/*************************** BASE CLASS OF PROJECT ****************************/
class SBS_WP extends DB_Interface {
  var $title;		// Page title
  var $decor_folder;	// Decoration folder
  var $decor_file;	// Decoration file
  var $keywords;	// Page additional keywords
  var $out;		// Main content
  var $write_hf;	// Writes or not a decoration of a page
  var $mmm_403;		// Value of "mmm" in case of error 403 ("Forbidden")
  var $mmm_404;		// Value of "mmm" in case of error 404 ("Not found")
  var $email_support;	// Support service e-mail(s)        
  var $email_admin;	// E-mail(s) for technical questions
  var $perm_dnd;	// Indicator of permission

  function SBS_WP()
  {
    $this->write_hf = TRUE;
    $this->lng_codes = array('ru'=>'russian|', 'en'=>'english|english',
      'de'=>'german|deutsch', 'fr'=>'french|fran&#231;ais',
      'by'=>'belorussian|', 'cn'=>'chinese|',
      'es'=>'spanish|', 'fi'=>'finnish|',
      'it'=>'italian|', 'jp'=>'japanese|',
      'pl'=>'polish|', 'se'=>'swedish',
      'ua'=>'ukrainian|', 'cs'=>'Czech|',
      'nl'=>'Dutch|', 'el'=>'Greek|',
      'he'=>'Hebrew|', 'hu'=>'Hungarian|',
      'kr'=>'Korean|', 'ro'=>'Romanian|',
      'sk'=>'Slovak|', 'sl'=>'Slovenian|',
      'tr'=>'Turkish|'); // Codes of languages
  }

  // Gets full language title by its code
  function get_lng_title($lng_code, $t = 0 /*0 - english, 1 - national*/)
  {
    $tmp = explode('|',$this->lng_codes[$lng_code]);
    $out = $tmp[$t];
    if ($out == '') $out = $tmp[0];
    if ($out == '') $out = $lng_code;
    return ucfirst($out);
  }

  // Counts an intervals between checkpoints of run of program and
  // return intervals
  // $out_HTML: if TRUE intervals as a HTML-table, else as array
  function runtime_count($out_HTML = FALSE)
  {
    $tmp = explode(' ', $this->runtime[start]);
    $this->runtime[start] = $tmp[1] + $tmp[0];
    $tmp = explode(' ', $this->runtime[after_includes]);
    $this->runtime[after_includes] = $tmp[1] + $tmp[0];
    $tmp = explode(' ', $this->runtime[before_lng]);
    $this->runtime[before_lng] = $tmp[1] + $tmp[0];
    $tmp = explode(' ', $this->runtime[after_lng]);
    $this->runtime[after_lng] = $tmp[1] + $tmp[0];
    $tmp = explode(' ', $this->runtime[before_decor]);
    $this->runtime[before_decor] = $tmp[1] + $tmp[0];
    $tmp = explode(' ', $this->runtime[before_echo]);
    $this->runtime[before_echo] = $tmp[1] + $tmp[0];
    $tmp = explode(' ', $this->runtime[finish]);
    $this->runtime[finish] = $tmp[1] + $tmp[0];

    $intervals['start - finish'] = $this->runtime[finish] - $this->runtime[start];
    $intervals['start - after_includes'] = $this->runtime[after_includes] - $this->runtime['start'];
    $intervals['after_includes - before_lng'] = $this->runtime[before_lng] - $this->runtime['after_includes'];
    $intervals['before_lng - after_lng'] = $this->runtime[after_lng] - $this->runtime[before_lng];
    $intervals['after_lng - before_decor'] = $this->runtime[before_decor] - $this->runtime[after_lng];
    $intervals['before_decor - before_echo'] = $this->runtime[before_echo] - $this->runtime[before_decor];
    $intervals['before_echo - finish'] = $this->runtime[finish] - $this->runtime['before_echo'];
    if ($out_HTML) {
      $out = '
	<b>Statistics of runtime</b>
	<table class="main_table">
	<thead>
	<tr><th>Interval</th><th>Time, s</th><th>Actions</th></tr>
	</thead>
	<tbody>
	<tr>
		<td>start - after_includes</td>
		<td>'.$intervals['start - after_includes'].'</td>
		<td>Including of auxiliary libraries</td>
	</tr>
	<tr>
		<td>after_includes - before_lng</td>
		<td>'.$intervals['after_includes - before_lng'].'</td>
		<td>Setting a variables, authentication</td>
	</tr>
	<tr>
		<td>before_lng - after_lng</td>
		<td>'.$intervals['before_lng - after_lng'].'</td>
		<td>Including language constants</td>
	</tr>
	<tr>
		<td>after_lng - before_decor</td>
		<td>'.$intervals['after_lng - before_decor'].'</td>
		<td>Setting a variables, checking permission, including Project script</td>
	</tr>
	<tr>
		<td>before_decor - before_echo</td>
		<td>'.$intervals['before_decor - before_echo'].'</td>
		<td>Processing of Decoration</td>
	</tr>
	<tr>
		<td>before_echo - finish</td>
		<td>'.$intervals['before_echo - finish'].'</td>
		<td>"Echo" of result</td>
	</tr>
	</tbody>
	<thead>
	<tr>
		<th align="left">start - finish</th>
		<th align="left">'.$intervals['start - finish'].'</th>
		<th align="left">Total runtime</th>
	</tr>
	</thead>
	</table>
      ';
      return $out;
    } else return $intervals;
  }

  // Checks authority of a current logged user
  // $owner - ID of owner, $ug - groups of users, which can be allowed;
  // $ug can be string like '43562' for several groups;
  // $ug, $owner must be always in apostrophes!
  // Out: TRUE if allowed, FALSE if denied
  function check_authority($ug, $owner = '')
  {
    global $pers_set;
    // Any group
    if ($ug == '*') return TRUE;
    // This is admin
    if ($pers_set[ug]!='' and $pers_set[ug]=='0') return TRUE;
    // This is owner
    if ($owner!='' and $owner==$pers_set[id] and @substr_count($ug, '-')==0) return TRUE;
    // Group allowed
    if (@substr_count($ug, $pers_set[ug]) > 0) return TRUE;
    return FALSE;
  }

  // Authorization
  // Out: 0 if succesfully, 1 if user not found
  function auth($login, $password) {
    $res = 1;
    if (file_exists(_MOBJ_MODULES_FOLDER_.'u5/lib_u5.php')) {// Loading with module U5
      include_once _MOBJ_MODULES_FOLDER_.'u5/lib_u5.php';
      $o_u5 = new U5;
      if ($tmp_pf = $o_u5->u5get_user_by_login($login, $password)) {
        unset($_SESSION['pers_set']);
        $_SESSION['pers_set'] = $tmp_pf;
        $this->log_event(_LNG_U00_LOG1_,$_SESSION['pers_set'][id]);
        $res = 0;
      }
    } else { // Trying to load built-in admin profile
      $pers_set = FALSE;
      if ($login==$this->admin_profile[login] and $password==$this->admin_profile[psw]) {
        unset($_SESSION['pers_set']);
        $_SESSION['pers_set']		= $this->admin_profile;
        $_SESSION['pers_set'][psw]	= md5($this->admin_profile[psw]);
        $res = 0;
      }
    }
    return $res;
  }
}

/*************************** OTHER FUNCTIONS **********************************/
// Addes a constants from external language file to specified file
// $ext_file - Filename
// $ext_file_name - Real file name
// $mdl_no - Destination module number
function add_ext_lang($ext_file, $ext_file_name, $mdl_no)
{
  preg_match ("/lng_(.*?)\.php/",$ext_file_name,$tmp);
  if (!empty($tmp[1])) {
    $val = $tmp[1];
    $path_to_lang = _MOBJ_MODULES_FOLDER_;
    if ($mdl_no != '') $path_to_lang .= 'u'.intval($mdl_no).'/';
    $fname = $path_to_lang."lang/lng_$val.php";
    if (file_exists($fname)) {
      $fp = fopen($fname,"r");
      $dump = fread($fp,filesize($fname));
      fclose($fp);
      $dump = substr(trim($dump),0,strlen(trim($dump))-2);
    } else $dump = "<?php // This is automatically created file, do not edit its manually!\n";
    // Getting external constants
    $fp = fopen($ext_file,"r");
    $dump_ext = fread($fp,filesize($ext_file));
    fclose($fp);
    preg_match_all ("/(define(.*?)\'\);)/",$dump_ext,$tmp);
    // Adding constants
    foreach ($tmp[1] as $str) {
      $dump .= "$str\n";
    }
    $dump .= "?>";
    // Writing to file
    @touch($fname);
    @chmod($fname,0777);
    $fp = fopen($fname,"w");
    fwrite($fp,$dump);
    fclose($fp);
    $res = 0;
  } else $res = 1;
  return $res;
}

// Gets available language files (return array with languages codes)
function get_lang_codes($mdl_no = '')
{
  $path_to_lang = _MOBJ_MODULES_FOLDER_;
  if ($mdl_no != '') $path_to_lang .= 'u'.intval($mdl_no).'/';
  if ($dir = @opendir($path_to_lang."lang/")) {
    while (($file = readdir($dir)) !== false) {
      if ($file!='.' && $file!='..' && filetype($path_to_lang."lang/".$file)=='file') {
        preg_match ("/lng_(.*?)\.php/",$file,$tmp);
        $fnames[] = $tmp[1];
      }
    }
    closedir($dir);
  }
  return $fnames;
}

// Tries to redirect from wrong typed address
function get_script_name()
{
  global $REQUEST_URI;
  preg_match_all ("/".str_replace('/','\/',_MOBJ_LOCAL_PATH_)."(.*?)$/", $REQUEST_URI, $tmp_1); // Local part of address
  $tmp_2 = explode('?', $tmp_1[1][0]); // Before "?"
  if ($tmp_2[1]) $query_string = '&'.$tmp_2[1]; // Query string
  $tmp_3 = explode('.', $tmp_2[0]); // Before extension
  if (substr($tmp_3[0],strlen($tmp_3[0])-1,1) == '/') $tmp_3[0] .= 'index'; // Adding "index" if only folder specified
  header("HTTP/1.0 200 OK");
  header("Location: "._MOBJ_LOCAL_PATH_."index.php?mmm=".$tmp_3[0].$query_string);
}

// Generates an antibot code and picture
function antibot_image($digits_q, $bg_image, $font, $color)
{
  global $pers_set;

  for ($I=0;$I<$digits_q;$I++) $antibot_code = $antibot_code.rand(0,9);

  $pers_set[antibot_code] = $antibot_code;

  $img		= ImageCreateFromJpeg($bg_image);
  $img_size	= getimagesize($bg_image);

  $x = ($img_size[0] - strlen($antibot_code) * imagefontwidth($font))/2;
  $y = ($img_size[1] - imagefontheight($font))/2;

  $color = imagecolorallocate($img, hexdec(substr($color,1,2)), hexdec(substr($color,3,2)), hexdec(substr($color,5,2)));
  imagestring($img, $font, $x, $y, $antibot_code, $color);

  header("Content-type: image/gif");
  imagejpeg($img);
}

// Loads a language constants
// $path with slash at end
function load_lng($path = '')
{
  global $pers_set, $HTTP_ACCEPT_LANGUAGE;
  @include_once _MOBJ_MODULES_FOLDER_.$path.'lang/lng_'.$pers_set[lng].'.php';
  @include_once _MOBJ_MODULES_FOLDER_.$path.'lang/lng_'.$HTTP_ACCEPT_LANGUAGE.'.php';
  @include_once _MOBJ_MODULES_FOLDER_.$path.'lang/lng_en.php'; // Default language, if not found any other
}
?>