/*******************************************************************************
Ardzo.JSCalendar. V1.3. Copyright (C) 2006 - 2008 Richter
Additional information: http://wpdom.com, richter@wpdom.com
*******************************************************************************/

// Main object
var ArdzoCalendar = {
  LngEn : {
    _LNG_CAL_D1_: 'Mn',
    _LNG_CAL_D2_: 'Tu',
    _LNG_CAL_D3_: 'Wd',
    _LNG_CAL_D4_: 'Th',
    _LNG_CAL_D5_: 'Fr',
    _LNG_CAL_D6_: 'St',
    _LNG_CAL_D7_: 'Sn',
    _LNG_CAL_M1_: 'January',
    _LNG_CAL_M2_: 'February',
    _LNG_CAL_M3_: 'March',
    _LNG_CAL_M4_: 'April',
    _LNG_CAL_M5_: 'May',
    _LNG_CAL_M6_: 'June',
    _LNG_CAL_M7_: 'July',
    _LNG_CAL_M8_: 'August',
    _LNG_CAL_M9_: 'September',
    _LNG_CAL_M10_: 'October',
    _LNG_CAL_M11_: 'November',
    _LNG_CAL_M12_: 'December',
    _LNG_CAL_TODAY_: 'TODAY'
  },
  LngRu : {
    _LNG_CAL_D1_: 'Пн',
    _LNG_CAL_D2_: 'Вт',
    _LNG_CAL_D3_: 'Ср',
    _LNG_CAL_D4_: 'Чт',
    _LNG_CAL_D5_: 'Пт',
    _LNG_CAL_D6_: 'Сб',
    _LNG_CAL_D7_: 'Вс',
    _LNG_CAL_M1_: 'Январь',
    _LNG_CAL_M2_: 'Февраль',
    _LNG_CAL_M3_: 'Март',
    _LNG_CAL_M4_: 'Апрель',
    _LNG_CAL_M5_: 'Май',
    _LNG_CAL_M6_: 'Июнь',
    _LNG_CAL_M7_: 'Июль',
    _LNG_CAL_M8_: 'Август',
    _LNG_CAL_M9_: 'Сентябрь',
    _LNG_CAL_M10_: 'Октябрь',
    _LNG_CAL_M11_: 'Ноябрь',
    _LNG_CAL_M12_: 'Декабрь',
    _LNG_CAL_TODAY_: 'СЕГОДНЯ'
  },
  TargetIDObj : null,

  // Opens a calendar
  open : function (TargetID, Lang, dLeft, dTop)
  {
    if (Lang == 'ru') this.Lng = this.LngRu; else this.Lng = this.LngEn;
    if (document.getElementById('ardzo_calendar')) { // Close if already open
      this.close();
    } else {
      TargetIDObj = document.getElementById(TargetID);
      if (!dLeft) var dLeft = 0;
      if (!dTop) var dTop = 0;
      CalendarDiv = document.createElement('DIV');
      CalendarDiv.setAttribute('id', 'ardzo_calendar');

      var Content;
      Content ='<table border="0" cellpadding=0 cellspacing=0 width="100%"><tr><td><SELECT ID=month class="selects" onchange="ArdzoCalendar.display(this.selectedIndex, Year.selectedIndex+1900)">';
      Content +='<OPTION>'+this.Lng._LNG_CAL_M1_+'<OPTION>'+this.Lng._LNG_CAL_M2_+'<OPTION>'+this.Lng._LNG_CAL_M3_+'<OPTION>'+this.Lng._LNG_CAL_M4_+'<OPTION>'+this.Lng._LNG_CAL_M5_+'<OPTION>'+this.Lng._LNG_CAL_M6_+'<OPTION>'+this.Lng._LNG_CAL_M7_+'<OPTION>'+this.Lng._LNG_CAL_M8_+'<OPTION>'+this.Lng._LNG_CAL_M9_+'<OPTION>'+this.Lng._LNG_CAL_M10_+'<OPTION>'+this.Lng._LNG_CAL_M11_+'<OPTION>'+this.Lng._LNG_CAL_M12_+'</SELECT></td><td align=right>';
      Content +='<SELECT ID="year" class="selects" onchange="ArdzoCalendar.display(Month.selectedIndex,this.selectedIndex+1900)">';
      for (var i=1900; i<2100; i++) Content += "<OPTION>"+i;
      Content +='</SELECT></td></tr></table>';
      Content +='<table id="cal_table"><thead>';
      Content +='<tr>';
      Content +='<th class="header_rest">'+this.Lng._LNG_CAL_D7_+'</th><th>'+this.Lng._LNG_CAL_D1_+'</th><th>'+this.Lng._LNG_CAL_D2_+'</th><th>'+this.Lng._LNG_CAL_D3_+'</th><th>'+this.Lng._LNG_CAL_D4_+'</th><th>'+this.Lng._LNG_CAL_D5_+'</th><th>'+this.Lng._LNG_CAL_D6_+'</th>';
      Content +='</tr></thead><tbody>';
      for (var i=0; i<7; i++) Content +="<tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>";
      Content +="</tbody></table>";
      Content +="<table border=0 cellpadding=0 cellspacing=0 width='100%'><tr><td><INPUT TYPE=button class=control1 VALUE='<<' onClick=ArdzoCalendar.setYear(-1)></td>";
      Content +='<td><INPUT TYPE=button class=control1 VALUE="<" onClick="ArdzoCalendar.setMonth(-1)"></td>';
      Content +='<td><INPUT TYPE="button" class="control2" VALUE="'+this.Lng._LNG_CAL_TODAY_+'" onClick="ArdzoCalendar.setToday()" /></td>';
      Content +='<td><INPUT TYPE=button class="control3" VALUE=">" onClick="ArdzoCalendar.setMonth(1)"></td>';
      Content +="<td><INPUT TYPE=button class=control3 VALUE='>>' onblur='Month.focus()' onClick=ArdzoCalendar.setYear(1)></td></tr></table>";
  
      CalendarDiv.innerHTML	= Content;
      CalendarDiv.style.position	= 'absolute';
      CalendarDiv.style.left	= this.calcLeft(TargetIDObj) + dLeft + 'px';
      CalendarDiv.style.top	= this.calcTop(TargetIDObj) + TargetIDObj.offsetHeight + dTop + 'px';
      document.body.appendChild(CalendarDiv);
      CalTable	= document.getElementById('cal_table');
      Month	= document.getElementById('month');
      Year	= document.getElementById('year');
      if (TargetIDObj) {
        var x_day	= parseInt(TargetIDObj.value.substr(8,2), 10);
        var x_month	= parseInt(TargetIDObj.value.substr(5,2), 10);
        var x_year	= parseInt(TargetIDObj.value.substr(0,4), 10);
        if (x_day > 0 && x_day <= this.getDaysInMonth(x_month,x_year) && x_month  > 0 && x_month < 13 && x_year > 1899 && x_year < 2100){
          day = x_day;
          Month.selectedIndex = x_month-1;
          Year.selectedIndex = x_year-1900;
          this.display(x_month-1,x_year,x_day);
        } else
          this.setToday();
      } else
        this.setToday();
    }
  },

  // Closes a calendar
  close : function ()
  {
    document.body.removeChild(CalendarDiv);
  },

  // Fills a calendar data
  display : function (x_month, x_year, x_day)
  {
    x_month	= parseInt(x_month, 10);
    x_year	= parseInt(x_year, 10);
    var days	= this.getDaysInMonth(x_month+1, x_year);
    if (x_month > 1) var days_before = this.getDaysInMonth(x_month,x_year);
    else var days_before = this.getDaysInMonth(12,x_year-1);
    if (day > days) day=days;
    if (!x_day) x_day=day;
    var curr_day = 0;
    var firstOfMonth = new Date (x_year, x_month, 1);
    var startingPos = firstOfMonth.getDay();
    for (i=0; i<42; i++) {
      curr_day=i-startingPos+1;
      (CalTable.rows[Math.floor(i/7)+1].cells[i%7].cellIndex>0) ? CalTable.rows[Math.floor(i/7)+1].cells[i%7].className="day":CalTable.rows[Math.floor(i/7)+1].cells[i%7].className="day_rest";
      if (curr_day <= 0 ) {
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].innerHTML=curr_day + days_before;
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].className="day_disabled";
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].onmouseover="";
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].onmouseout="";}
      else if (curr_day > 0 && curr_day <= days) {
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].innerHTML = curr_day;
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].onmouseover = this.eventHandlerOver;
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].onmouseout = this.eventHandlerOut;
      }
      else if (curr_day > days) {
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].innerHTML=curr_day-days;
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].className="day_disabled"
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].onmouseover="";
        CalTable.rows[Math.floor(i/7)+1].cells[i%7].onmouseout="";
      }
      CalTable.rows[Math.floor(i/7)+1].cells[i%7].onclick = this.eventHandlerClick;
      if (curr_day==x_day) CalTable.rows[Math.floor(i/7)+1].cells[i%7].className="day_selected";
    }
  },

  // Support "mouseover"-event
  eventHandlerOver : function (anEvObj)
  {
    if (this.className != "day_selected")
      this.className = "day_mouseover";
  },

  // Support "mouseout"-event
  eventHandlerOut : function (anEvObj)
  {
    if (this.className != "day_selected")
      (this.cellIndex>0) ? this.className="day":this.className="day_rest";
  },

  // Handler of double click
  eventHandlerClick : function (anEvObj)
  {
    var str_day		= "";
    var str_month	= Month.selectedIndex + 1;
    var str_year	= Year.selectedIndex + 1900;
    day = this.innerHTML;
    if (this.className == "day_disabled") {
      (parseInt(day, 10) > 20) ? ArdzoCalendar.setMonth(-1): ArdzoCalendar.setMonth(1);
    } else {
      (day.toString().length==1)? str_day="0"+day : str_day=day;
      if (str_month<10) str_month = "0"+str_month;
      TargetIDObj.value = (str_year + "-" + str_month + "-" + str_day);
      ArdzoCalendar.close();
    }
  },

  // Jumps to year
  setYear : function (val)
  {
    if (!isNaN(val)) {
      x_year = Year.selectedIndex+1900;
      x_year = Number(x_year) + val;
      if (x_year < 1900) x_year = 1900;
      if (x_year > 2099) x_year = 2099;
      Year.selectedIndex = x_year-1900;
      this.display(Month.selectedIndex, Year.selectedIndex+1900);
    }
  },

  // Jumps to month
  setMonth : function (val)
  {
    if (!isNaN(val)) {
      var i = 0;
      var x_month = Month.selectedIndex;
      i = x_month + val;
      x_month = i%12;
      if (x_month < 0) x_month = x_month + 12;
      Month.selectedIndex = x_month;
      this.setYear(Math.floor(i/12));
      this.display(Month.selectedIndex, Year.selectedIndex+1900);
    }
  },

  // Jumps to today
  setToday : function ()
  {
    var now	= new Date();
    var x_day	= now.getDate();
    var x_month	= now.getMonth();
    var x_year	= now.getFullYear();
    day		= x_day;
    Month.selectedIndex = x_month;
    Year.selectedIndex = x_year - 1900;
    this.display(Month.selectedIndex, Year.selectedIndex + 1900, x_day);
  },

  // Return quantity of days in month
  getDaysInMonth : function (x_month,x_year)
  {
    var days;
    if (x_month==1 || x_month==3 || x_month==5 || x_month==7 || x_month==8 || x_month==10 || x_month==12) days = 31;
    else if (x_month==4 || x_month==6 || x_month==9 || x_month==11) days = 30;
    else if (x_month==2) {
      if (this.isLeapYear(x_year)) days = 29;
      else days = 28;
    }
    return (days);
  },

  // Checks leap year
  isLeapYear : function (x_year)
  {
    if (((x_year % 4)==0) && ((x_year % 100)!=0) || ((x_year % 400)==0)) {
      return (true);
    } else {
      return (false);
    }
  },

  calcLeft : function (Obj)
  {
    var x_ret = 0;
    var oParent = Obj.offsetParent;
    if (oParent == null) return 0;
    else x_ret=Obj.offsetLeft + this.calcLeft(oParent);
    return x_ret;
  },

  calcTop : function (Obj)
  {
    var x_ret = 0;
    var oParent = Obj.offsetParent;
    if (oParent == null) return 0;
    else x_ret = Obj.offsetTop + this.calcTop(oParent);
    return x_ret;
  }
}