<?php
$s_folder = '../../htdocs/present'; //Start folder for search
$incl_f_mask = array('php','txt'); //Array of desired extensions (or empty if not needed)
$excl_f_mask = array(); //Array of unnecessary extensions (or empty if not needed)
$out_file = 'e-mails.dat'; //Out file
$log_file = '1.log';
$out_mode = 2; //Processing info mode: 0 - not writes, 1 - writes to sreen, 2 - writes to log file

//Return '1' if file name is good by mask
function mask_check($file_name) {
  global $incl_f_mask, $excl_f_mask;
  $res = '0';

  if (count($incl_f_mask) > 0) {
    reset($incl_f_mask);
    while (list($I,$val) = each($incl_f_mask)) {
      if (preg_match ("/(.*?)".$val."$/",$file_name)) $res = '1';
    }
  } else $res = 1;

  if (count($excl_f_mask) > 0) {
    reset($excl_f_mask);
    while (list($I,$val) = each($excl_f_mask)) {
      if (preg_match ("/(.*?)".$val."$/",$file_name)) $res = '0';
    }
  }

  return $res;
}

//Recursive search in folders
function f_search($s_folder) {
  global $f_ar;
  if ($dir = @opendir("$s_folder/")) {
    while (($file = readdir($dir)) !== false) {
      if ($file!='.' && $file!='..') {
        if (filetype("$s_folder/".$file)=='dir') {
	  f_search($s_folder.'/'.$file);
        } else {
          if (mask_check($file))
          $f_ar[] = $s_folder.'/'.$file;
        }
      }
    }
    closedir($dir);
  }
}

//Searches e-mails and writes it to file (file must be open!)
//Return found addresses quantity
function get_emails($filename1) {
  global $fp_out;
  $fp = fopen($filename1,"r");
  $dump = fread($fp,filesize($filename1));
  fclose($fp);
  //Regular expression for e-mail address
  preg_match_all ("/(([\w\.\-\/]+)\@([\w\.\-\/]+)\.([a-z])([a-z]+))/",$dump,$out);
//  preg_match_all ("/<h2>(.*?)<\/h2>/",$dump,$out);
  if (count($out[1]) > 0) {
    while (list($I,$val) = each($out[1])) {
      fwrite($fp_out,"$val\n");
    }
  }
  return count($out[1]);
}

f_search($s_folder);

$out = '
<h1>E-mail finder</h1>
Search started at: '.date('d.m.Y H:i:s').'<br>
Start folder: '.$s_folder.'<br>
Desired files extensions: ';
@reset($incl_f_mask);
while (list($I,$val) = @each($incl_f_mask)) $out .= $val.', ';
$out .= '<br>
Unnecessary files extensions: ';
@reset($excl_f_mask);
while (list($I,$val) = @each($excl_f_mask)) $out .= $val.', ';
$out .= '<br>
Found files: '.count($f_ar).'<br>
List of found files:<p>
';
$fp_out = fopen($out_file,"w");
while (list($I,$val) = @each($f_ar)) {
  $f_e = get_emails($val);
  $out .= '<b>'.$val.'</b> ... processed. '.($f_e>0?$f_e.' found':'').'<br>';
}
fclose($fp_out);
$out .= '<p>E-mails writed in '.$out_file.'
<hr size=1>
<p align=center>Copyright &#169; 2003 <a href="http://web-pro.da.ru" target=_blank>Richter</a>
';

//Result writing
if ($out_mode == 1) echo $out;
elseif ($out_mode == 2) {
  $fp = fopen($log_file,"w");
  $out = strip_tags(str_replace('<br>',"\n",$out));

  fwrite($fp,$out);
  fclose($fp);
}
?>